// GMSH script to generate the mesh for the 3d heat sink
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Design from: PrePoMax tutorial #21 (https://www.youtube.com/watch?v=RB_tL699XuI)
// Author: Andrea Pavan
// Date: 26/12/2022


//parameters
l1 = 54.4e-3;		//domain x size
l2 = 43e-3;		//domain y size
l3 = 60e-3;		//domain z size
tb = 3e-3;		//bottom thickness
tf = 4e-3;		//fins thickness
sf = 12.8e-3;		//fins spacing

surfaceMeshSize = 1.5e-3;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {0, 0, 0, surfaceMeshSize};
Point(2) = {l1, 0, 0, surfaceMeshSize};
Point(3) = {l1, l2, 0, surfaceMeshSize};
Point(4) = {l1-tf, l2, 0, surfaceMeshSize};
Point(5) = {l1-tf, 0+tb, 0, surfaceMeshSize};
Point(6) = {l1-tf-sf, 0+tb, 0, surfaceMeshSize};
Point(7) = {l1-tf-sf, l2, 0, surfaceMeshSize};
Point(8) = {l1-2*tf-sf, l2, 0, surfaceMeshSize};
Point(9) = {l1-2*tf-sf, 0+tb, 0, surfaceMeshSize};
Point(10) = {l1-2*tf-2*sf, 0+tb, 0, surfaceMeshSize};
Point(11) = {l1-2*tf-2*sf, l2, 0, surfaceMeshSize};
Point(12) = {l1-3*tf-2*sf, l2, 0, surfaceMeshSize};
Point(13) = {l1-3*tf-2*sf, 0+tb, 0, surfaceMeshSize};
Point(14) = {l1-3*tf-3*sf, 0+tb, 0, surfaceMeshSize};
Point(15) = {l1-3*tf-3*sf, l2, 0, surfaceMeshSize};
Point(16) = {0, l2, 0, surfaceMeshSize};

Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 5};
Line(5) = {5, 6};
Line(6) = {6, 7};
Line(7) = {7, 8};
Line(8) = {8, 9};
Line(9) = {9, 10};
Line(10) = {10, 11};
Line(11) = {11, 12};
Line(12) = {12, 13};
Line(13) = {13, 14};
Line(14) = {14, 15};
Line(15) = {15, 16};
Line(16) = {16, 1};

Curve Loop(1) = {16, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
Plane Surface(1) = {1};
Extrude {0, 0, l3} {
  Curve{1}; Curve{2}; Curve{3}; Curve{4}; Curve{5}; Curve{6}; Curve{7}; Curve{8}; Curve{9}; Curve{10}; Curve{11}; Curve{12}; Curve{13}; Curve{14}; Curve{15}; Curve{16}; 
}
Curve Loop(18) = {21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 48, 19};
Plane Surface(18) = {18};
Surface Loop(1) = {17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 18, 1};
Volume(1) = {1};
